#pragma once

#include <yandex/maps/wiki/validator/common.h>
#include <yandex/maps/wiki/validator/common/relation.h>

#include <yandex/maps/wiki/common/rd/lane.h>
#include <memory>
#include <vector>

namespace maps::wiki::validator {

class CondDirectionSign
{
public:
    CondDirectionSign(
            TId id,
            const AttrMap& attributes,
            const Relations& /* masters */,
            const Relations& slaves);

    TId id() const
    { return id_; }

    TId viaJunction() const
    { return viaJunction_; }

    TId fromRoadElement() const
    { return fromRoadElement_; }

    const std::vector<std::pair<TSeqNum, TId>>& toRoadElements() const
    { return toRoadElements_; }

    const std::vector<TId>& condDsElIds() const
    { return condDsElIds_; }

    common::LaneDirection direction() const
    { return direction_; }

private:
    TId id_;
    TId viaJunction_;
    TId fromRoadElement_;
    std::vector<std::pair<TSeqNum, TId>> toRoadElements_;
    std::vector<TId> condDsElIds_;
    common::LaneDirection direction_;
};

} // namespace maps::wiki::validator
