#pragma once

#include <yandex/maps/wiki/validator/common.h>

#include <yandex/maps/wiki/validator/common/relation.h>

#include <string>

namespace maps::wiki::validator {

class CondDirectionSignElement
{
public:
    CondDirectionSignElement(
            TId id,
            const AttrMap& attributes_,
            const Relations& masters,
            const Relations& /* slaves */);

    TId id() const
    { return id_; }

    const std::string& name() const
    { return name_; }

    const std::string& lang() const
    { return lang_; }

    const std::string& type() const
    { return type_; }

    const std::string& color() const
    { return name_; }

    const std::string& icon() const
    { return icon_; }

    int order() const
    { return order_; }

    bool newLine() const
    { return newLine_; }

    TId parent() const
    { return parent_; }

private:
    TId id_;
    std::string name_;
    std::string lang_;
    std::string type_;
    std::string color_;
    std::string icon_;
    int order_;
    bool newLine_;
    TId parent_;
};

} // namespace maps::wiki::validator
