#pragma once

#include <yandex/maps/wiki/validator/common.h>

#include <yandex/maps/wiki/common/rd/access_id.h>
#include <yandex/maps/wiki/common/rd/cond_type.h>
#include <yandex/maps/wiki/validator/objects/vehicle_restriction_common.h>

#include <vector>

namespace maps::wiki::validator {

class Condition
{
public:
    Condition(
        TId id,
        const AttrMap& attributes,
        const Relations& masters,
        const Relations& slaves);

    TId id() const
    { return id_; }

    common::ConditionType type() const
    { return type_; }

    common::AccessId accessId() const
    { return accessId_; }

    TId viaJunction() const
    { return viaJunction_; }

    TId fromRoadElement() const
    { return fromRoadElement_; }

    const std::vector<std::pair<TSeqNum, TId>>& toRoadElements() const
    { return toRoadElements_; }

    const std::vector<TId>& schedules() const
    { return schedules_; }

    const std::unique_ptr<VehicleRestrictionParameters>& vehicleRestrictionParameters() const
    { return vehicleRestrictionParameters_; }

private:
    TId id_;
    common::ConditionType type_;
    common::AccessId accessId_;
    TId viaJunction_;
    TId fromRoadElement_;
    std::vector<std::pair<TSeqNum, TId>> toRoadElements_;
    std::vector<TId> schedules_;
    std::unique_ptr<VehicleRestrictionParameters> vehicleRestrictionParameters_;
};

} // namespace maps::wiki::validator
