#pragma once

#include <yandex/maps/wiki/validator/common.h>

#include <yandex/maps/wiki/common/rd/access_id.h>
#include <yandex/maps/wiki/common/rd/lane.h>

#include <vector>

namespace maps::wiki::validator {

class ConditionLane
{
public:
    ConditionLane(
        TId id,
        const AttrMap& attributes,
        const Relations& masters,
        const Relations& slaves);

    TId id() const
    { return id_; }

    common::LaneDirection lane() const
    { return lane_; }

    size_t laneMin() const
    { return laneMin_; }

    size_t laneMax() const
    { return laneMax_; }

    common::AccessId accessId() const
    { return accessId_; }

    TId viaJunction() const
    { return viaJunction_; }

    TId fromRoadElement() const
    { return fromRoadElement_; }

    const std::vector<std::pair<TSeqNum, TId>>& toRoadElements() const
    { return toRoadElements_; }

    const std::vector<TId>& schedules() const
    { return schedules_; }

private:
    TId id_;
    common::LaneDirection lane_;
    size_t laneMin_;
    size_t laneMax_;
    common::AccessId accessId_;
    TId viaJunction_;
    TId fromRoadElement_;
    std::vector<std::pair<TSeqNum, TId>> toRoadElements_;
    std::vector<TId> schedules_;
};

} // namespace maps::wiki::validator
