#pragma once

#include <yandex/maps/wiki/validator/common.h>
#include <yandex/maps/wiki/validator/objects/name.h>

#include <vector>

namespace maps::wiki::validator {

class ContourFeature
{
public:
    ContourFeature(
        TId id,
        const AttrMap& attributes,
        const Relations& masters,
        const Relations& slaves);

    TId id() const
    { return id_; }

    // Non-zero only if object category corresponds to multiple feature types
    TFeatureType featureType() const
    { return featureType_; }

    const std::vector<TId>& faces() const
    { return faces_; }

    const std::vector<NameRelation>& names() const
    { return names_; }

private:
    TId id_;
    TFeatureType featureType_;
    std::vector<TId> faces_;
    std::vector<NameRelation> names_;
};

} // namespace maps::wiki::validator
