#pragma once

#include <yandex/maps/wiki/validator/common.h>

#include <vector>

namespace maps::wiki::validator {

class Face
{
public:
    Face(
        TId id,
        const AttrMap& attributes,
        const Relations& masters,
        const Relations& slaves);

    TId id() const
    { return id_; }

    TId parent() const
    { return parent_; }

    const std::vector<TId>& edges() const
    { return edges_; }

    bool isInterior() const
    { return isInterior_; }

private:
    TId id_;
    TId parent_;
    std::vector<TId> edges_;
    bool isInterior_;
};

} // namespace maps::wiki::validator
