#pragma once

#include <yandex/maps/wiki/validator/common/relation.h>

#include <yandex/maps/wiki/validator/common.h>
#include <yandex/maps/wiki/validator/objects/name.h>
#include <maps/libs/geolib/include/polygon.h>

#include <memory>
#include <vector>

namespace maps::wiki::validator {

class IndoorLevel {
public:
    using TGeom = geolib3::Polygon2;
    IndoorLevel(
        TId id,
        TGeom geom,
        const AttrMap& attributes,
        const Relations& masters,
        const Relations& slaves);

    TId id() const
    { return id_; }

    const TGeom& geom() const
    { return geom_; }

    TId parent() const
    { return parent_; }

    const std::vector<NameRelation>& names() const
    { return names_; }

    bool isDefault() const
    { return isDefault_; }

    bool isUnderground() const
    { return isUnderground_; }

    size_t order() const
    { return order_; }

    const std::string& universal() const
    { return universal_; }

private:
    TId id_;
    TGeom geom_;
    TId parent_;
    std::vector<NameRelation> names_;
    bool isDefault_;
    bool isUnderground_;
    int order_;
    std::string universal_;
};

} // namespace maps::wiki::validator
