#pragma once

#include <yandex/maps/wiki/validator/common.h>
#include <yandex/maps/wiki/validator/objects/point_feature.h>

#include <unordered_set>

namespace maps::wiki::validator {

class IndoorPlan : public PointFeature
{
public:
    IndoorPlan(
        TId id,
        PointFeature::TGeom geom,
        const AttrMap& attributes,
        const Relations& masters,
        const Relations& slaves);

    std::unordered_set<TId> parentIds() const
    { return parentIds_; }

    bool isNotOperating() const
    { return isNotOperating_; }

private:
    std::unordered_set<TId> parentIds_;
    bool isNotOperating_;
};

} // namespace maps::wiki::validator
