#pragma once

#include <yandex/maps/wiki/validator/common.h>
#include <maps/libs/geolib/include/point.h>

namespace maps::wiki::validator {

class Junction
{
public:
    using TGeom = geolib3::Point2;

    Junction(
        TId id,
        TGeom geom,
        const AttrMap& attributes,
        const Relations& masters,
        const Relations& slaves);

    TId id() const
    { return id_; }

    const TGeom& geom() const
    { return geom_; }

    const std::vector<TId>& inElements() const
    { return inElements_; }

    const std::vector<TId>& outElements() const
    { return outElements_; }

private:
    TId id_;
    TGeom geom_;
    std::vector<TId> inElements_;
    std::vector<TId> outElements_;
};

} // namespace maps::wiki::validator
