#pragma once

#include <yandex/maps/wiki/validator/common.h>

namespace maps::wiki::validator {

struct NameRelation
{
    enum class Type {
        Official = 0,
        RenderLabel = 1,
        AddressLabel = 2,
        Short = 3,
        Synonym = 4,
        Old = 5
    };

    NameRelation(Type type_, TId id_) : type(type_), id(id_) { }

    Type type;
    TId id;
};

class Name
{
public:
    Name(
        TId id,
        const AttrMap& attributes,
        const Relations& masters,
        const Relations& slaves);

    TId id() const
    { return id_; }

    TId parentId() const
    { return parentId_; }

    const std::string& name() const
    { return name_; }

    const std::string& lang() const
    { return lang_; }

    NameRelation::Type type() const
    { return type_; }

    bool isLocal() const
    { return isLocal_; }

private:
    TId id_;
    TId parentId_;
    std::string name_;
    std::string lang_;
    NameRelation::Type type_;
    bool isLocal_;
};

} // namespace maps::wiki::validator
