#pragma once

#include <yandex/maps/wiki/validator/common.h>
#include <maps/libs/geolib/include/point.h>

#include <vector>

namespace maps::wiki::validator {

class ParkingControlledZone {
public:
    using TGeom = geolib3::Point2;

    ParkingControlledZone(
        TId id,
        TGeom geom,
        const AttrMap& attributes,
        const Relations& masters,
        const Relations& slaves);

    TId id() const
    { return id_; }

    const TGeom& geom() const
    { return geom_; }

    const std::vector<TId>& parkingLots() const
    { return parkingLots_; }

    const std::vector<TId>& linearParkingLots() const
    { return linearParkingLots_; }

private:
    TId id_;
    TGeom geom_;
    std::vector<TId> parkingLots_;
    std::vector<TId> linearParkingLots_;
};

} // namespace maps::wiki::validator
