#pragma once

#include <yandex/maps/wiki/validator/common.h>
#include <yandex/maps/wiki/validator/objects/name.h>
#include <maps/libs/enum_io/include/enum_io_fwd.h>
#include <maps/libs/geolib/include/point.h>

#include <vector>

namespace maps::wiki::validator {

class Poi {
public:
    enum class Location {
        Empty,
        EntranceSign,
        Indoor
    };

    enum class PositionQuality {
        Empty,
        Auto,
        Undefined,
        Approximate,
        User,
        Precise
    };

    using TGeom = geolib3::Point2;

    Poi(TId id,
        TGeom geom,
        const AttrMap& attributes,
        const Relations& masters,
        const Relations& slaves);

    TId id() const
    { return id_; }

    TFeatureType featureType() const
    { return featureType_; }

    const TGeom& geom() const
    { return geom_; }

    TId parent() const
    { return parent_; }

    struct AssignedObject {
        enum class Type
        {
            Building,
            UrbanAreal,
            Entrance
        };

        TId id;
        Type type;
    };

    const std::vector<AssignedObject>& assignedObjects() const
    { return assignedObjects_; }

    const std::vector<NameRelation>& names() const
    { return names_; }

    const std::string& businessId() const
    { return businessId_; }

    const std::string& businessRubricId() const
    { return businessRubricId_; }

    bool isGeoproduct() const
    { return isGeoproduct_; }

    const std::string& importSource() const
    { return importSource_; }
    const std::string& importSourceId() const
    { return importSourceId_; }

    Location location() const
    { return location_; }
    PositionQuality positionQuality() const
    { return positionQuality_; }

private:
    TId id_;
    TFeatureType featureType_;
    TGeom geom_;
    TId parent_;
    std::vector<AssignedObject> assignedObjects_;
    std::vector<NameRelation> names_;
    std::string businessId_;
    std::string businessRubricId_;
    bool isGeoproduct_;
    std::string importSource_;
    std::string importSourceId_;
    Location location_;
    PositionQuality positionQuality_;
};

DECLARE_ENUM_IO(Poi::Location);
DECLARE_ENUM_IO(Poi::PositionQuality);

} // namespace maps:wiki::validator
