#pragma once

#include <yandex/maps/wiki/validator/common.h>
#include <yandex/maps/wiki/validator/objects/name.h>
#include <maps/libs/geolib/include/point.h>

#include <vector>

namespace maps::wiki::validator {

class PointFeature {
public:
    using TGeom = geolib3::Point2;

    PointFeature(
        TId id,
        TGeom geom,
        const AttrMap& attributes,
        const Relations& masters,
        const Relations& slaves);

    TId id() const
    { return id_; }

    // Non-zero only if object category corresponds to multiple feature types
    TFeatureType featureType() const
    { return featureType_; }

    const TGeom& geom() const
    { return geom_; }

    TId parent() const
    { return parent_; }

    const std::vector<TId>& childFeatures() const
    { return childFeatures_; }

    const std::vector<NameRelation>& names() const
    { return names_; }

    const std::string& importSourceId() const
    { return importSourceId_; }

    const std::string& importSource() const
    { return importSource_; }

private:
    TId id_;
    TFeatureType featureType_;
    TGeom geom_;
    TId parent_;
    std::vector<TId> childFeatures_;
    std::vector<NameRelation> names_;
    std::string importSourceId_;
    std::string importSource_;
};

} // namespace maps::wiki::validator
