#pragma once

#include <yandex/maps/wiki/validator/common.h>
#include <yandex/maps/wiki/validator/objects/name.h>
#include <maps/libs/geolib/include/polygon.h>

#include <vector>

namespace maps::wiki::validator {

class PolygonFeature {
public:
    using TGeom = geolib3::Polygon2;

    PolygonFeature(
        TId id,
        TGeom geom,
        const AttrMap& attributes,
        const Relations& masters,
        const Relations& slaves);

    TId id() const
    { return id_; }

    // Non-zero only if object category corresponds to multiple feature types
    TFeatureType featureType() const
    { return featureType_; }

    const TGeom& geom() const
    { return geom_; }

    TId parent() const
    { return parent_; }

    const std::vector<NameRelation>& names() const
    { return names_; }

private:
    TId id_;
    TFeatureType featureType_;
    TGeom geom_;
    TId parent_;
    std::vector<NameRelation> names_;
};

} // namespace maps::wiki::validator
