#pragma once

#include <yandex/maps/wiki/validator/common.h>
#include <maps/libs/geolib/include/polyline.h>

namespace maps::wiki::validator {

class PolylineFeature {
public:
    using TGeom = geolib3::Polyline2;

    PolylineFeature(
        TId id,
        TGeom geom,
        const AttrMap& attributes,
        const Relations& masters,
        const Relations& slaves);

    TId id() const
    { return id_; }

    const TGeom& geom() const
    { return geom_; }

    TFeatureType featureType() const
    { return featureType_; }

    TId parent() const
    { return parent_; }

private:
    TId id_;
    TGeom geom_;
    TFeatureType featureType_;
    TId parent_;
};

} // namespace maps::wiki::validator
