#pragma once

#include <yandex/maps/wiki/validator/common.h>
#include <yandex/maps/wiki/validator/objects/name.h>

#include <vector>

namespace maps::wiki::validator {

class Region
{
public:
    using TGeom = geolib3::Point2;

    Region(
        TId id,
        TGeom geom,
        const AttrMap& attributes,
        const Relations& masters,
        const Relations& slaves);

    TId id() const
    { return id_; }

    const TGeom& geom() const
    { return geom_; }

    const std::vector<TId>& admUnits() const
    { return admUnits_; }

    const std::vector<TId>& adNeutrals() const
    { return adNeutrals_; }

    const std::vector<NameRelation>& names() const
    { return names_; }

private:
    TId id_;
    TGeom geom_;
    std::vector<TId> admUnits_;
    std::vector<TId> adNeutrals_;
    std::vector<NameRelation> names_;
};

} // namespace maps::wiki::validator
