#pragma once

#include <yandex/maps/wiki/validator/common.h>
#include <yandex/maps/wiki/validator/objects/name.h>

#include <vector>

namespace maps::wiki::validator {

class Road
{
public:
    Road(
        TId id,
        const AttrMap& attributes,
        const Relations& masters,
        const Relations& slaves);

    enum class Type
    {
        CityRoad = 1,
        Route = 2,
        Structure = 3,
        CityHighway = 4,
        CountryHighway = 5,
        Kilometer = 6,
        NamedExit = 7,

        Min = CityRoad,
        Max = NamedExit
    };

    struct AssociatedObject {
        enum class Type
        {
            NotSet,
            AdmUnit,
            Feature
        };

        TId id;
        Type type;
    };

    TId id() const
    { return id_; }

    Type type() const
    { return type_; }

    std::optional<int> searchClass() const
    { return searchClass_; }

    const std::vector<TId>& elements() const
    { return elements_; }

    AssociatedObject associatedObject() const
    { return associatedObject_; }

    const std::vector<NameRelation>& names() const
    { return names_; }

    TId addrUnity() const
    { return addrUnity_; }

private:
    TId id_;
    Type type_;
    std::optional<int> searchClass_;
    AssociatedObject associatedObject_;
    std::vector<TId> elements_;
    std::vector<NameRelation> names_;
    TId addrUnity_;
};

} // namespace maps::wiki::validator
