#pragma once

#include <yandex/maps/wiki/validator/common.h>

#include <yandex/maps/wiki/common/rd/access_id.h>
#include <maps/libs/ymapsdf/include/rd.h>
#include <yandex/maps/wiki/common/rd/fow.h>
#include <yandex/maps/wiki/common/rd/lane.h>
#include <yandex/maps/wiki/common/rd/struct_type.h>

#include <maps/libs/geolib/include/polyline.h>

#include <memory>
#include <vector>

namespace maps::wiki::validator {

class RoadElement
{
public:
    static const int MAX_FC = 10;

    using Direction = ymapsdf::rd::Direction;
    using TGeom = geolib3::Polyline2;

    RoadElement(
        TId id,
        TGeom geom,
        const AttrMap& attributes,
        const Relations& masters,
        const Relations& slaves);

    TId id() const
    { return id_; }

    const TGeom& geom() const
    { return geom_; }

    const std::vector<TId>& parents() const
    { return parents_; }

    std::optional<int> speedLimit() const
    { return speedLimit_; }
    std::optional<int> speedLimitT() const
    { return speedLimitT_; }
    std::optional<int> speedLimitTruck() const
    { return speedLimitTruck_; }
    std::optional<int> speedLimitTruckT() const
    { return speedLimitTruckT_; }

    const common::Lanes& fromLanes() const;
    const common::Lanes& toLanes() const;
    const std::string& openAt() const;

    TId startJunction() const
    { return startJunction_; }

    TId endJunction() const
    { return endJunction_; }

    int fc() const
    { return fc_; }

    int fromZlevel() const
    { return fromZlevel_; }

    int toZlevel() const
    { return toZlevel_; }

    common::AccessId accessId() const
    { return accessId_; }

    Direction direction() const
    { return direction_; }

    common::FOW fow() const
    { return fow_; }

    common::StructType structType() const
    { return structType_; }

    bool paved() const
    { return paved_; }

    bool residential() const
    { return residential_; }

    bool backBus() const
    { return backBus_; }

    bool backTaxi() const
    { return backTaxi_; }

    bool backBicycle() const
    { return backBicycle_; }

    bool dr() const
    { return dr_; }

    bool underConstruction() const
    { return underConstruction_; }

    bool toll() const
    { return toll_; }

    bool noScooterAccess() const
    { return noScooterAccess_; }

    bool noMotoAccess() const
    { return noMotoAccess_; }

private:
    TId id_;
    TGeom geom_;
    std::vector<TId> parents_;
    std::optional<int> speedLimit_;
    std::optional<int> speedLimitT_;
    std::optional<int> speedLimitTruck_;
    std::optional<int> speedLimitTruckT_;

    std::unique_ptr<common::Lanes> fromLanes_;
    std::unique_ptr<common::Lanes> toLanes_;
    std::unique_ptr<std::string> openAt_;

    TId startJunction_;
    TId endJunction_;
    int fc_;
    int fromZlevel_;
    int toZlevel_;

    common::AccessId accessId_;
    RoadElement::Direction direction_;
    common::FOW fow_;
    common::StructType structType_;

    bool paved_;
    bool residential_;
    bool backBus_;
    bool backTaxi_;
    bool backBicycle_;
    bool dr_;
    bool underConstruction_;
    bool toll_;
    bool noScooterAccess_;
    bool noMotoAccess_;
};

} // namespace maps::wiki::validator
