#pragma once

#include <yandex/maps/wiki/validator/common.h>

namespace maps::wiki::validator {

class RoadMarkingLinear
{
public:
    using TGeom = geolib3::Polyline2;

    RoadMarkingLinear(
        TId id,
        TGeom geom,
        const AttrMap& attributes,
        const Relations& masters,
        const Relations& slaves);

    TId id() const
    { return id_; }

    const TGeom& geom() const
    { return geom_; }

    const std::string& type() const
    { return type_; }

    bool temporary() const
    { return temporary_; }

    TId roadSurface() const
    { return roadSurface_; }

private:
    TId id_;
    TGeom geom_;
    std::string type_;
    bool temporary_;
    TId roadSurface_;
};

} // namespace maps::wiki::validator
