#pragma once

#include <yandex/maps/wiki/validator/common.h>

namespace maps::wiki::validator {

class RoadMarkingPoint
{
public:
    using TGeom = geolib3::Point2;

    RoadMarkingPoint(
        TId id,
        TGeom geom,
        const AttrMap& attributes,
        const Relations& masters,
        const Relations& slaves);

    TId id() const
    { return id_; }

    const TGeom& geom() const
    { return geom_; }

    TId roadSurface() const
    { return roadSurface_; }

private:
    TId id_;
    TGeom geom_;
    TId roadSurface_;
};

} // namespace maps::wiki::validator
