#pragma once

#include <yandex/maps/wiki/validator/common.h>

namespace maps::wiki::validator {

class RoadSurface
{
public:
    using TGeom = geolib3::Polygon2;

    RoadSurface(
        TId id,
        TGeom geom,
        const AttrMap& attributes,
        const Relations& masters,
        const Relations& slaves);

    TId id() const
    { return id_; }

    const TGeom& geom() const
    { return geom_; }

    const std::string& type() const
    { return type_; }

    int fromZlevel() const
    { return fromZlevel_; }

    int toZlevel() const
    { return toZlevel_; }

    const std::vector<TId>& polygonalMarkings() const
    { return polygonalMarkings_; }

    const std::vector<TId>& linearMarkings() const
    { return linearMarkings_; }

    const std::vector<TId>& pointMarkings() const
    { return pointMarkings_; }

private:
    TId id_;
    TGeom geom_;

    std::string type_;
    int fromZlevel_;
    int toZlevel_;

    std::vector<TId> polygonalMarkings_;
    std::vector<TId> linearMarkings_;
    std::vector<TId> pointMarkings_;
};

} // namespace maps::wiki::validator
