#pragma once

#include <yandex/maps/wiki/validator/common.h>
#include <yandex/maps/wiki/common/schedule.h>

namespace maps::wiki::validator {

class Schedule
{
public:
    Schedule(
        TId id,
        const AttrMap& attributes,
        const Relations& masters,
        const Relations& slaves);

    TId id() const
    { return id_; }

    const std::string& timeStart() const
    { return timeStart_; }

    const std::string& timeEnd() const
    { return timeEnd_; }

    const std::string& dateStart() const
    { return dateStart_; }

    const std::string& dateEnd() const
    { return dateEnd_; }

    common::WeekdayFlags weekdays() const
    { return weekdays_; }

    int frequency() const
    { return frequency_; }

    const std::string& departureTime() const
    { return departureTime_; }

    bool alternative() const
    { return alternative_; }

    struct AffectedObject
    {
        enum class Type
        {
            Unknown,
            Condition,
            Camera,
            TransportThread,
            CondLane,
            VehicleRestriction
        };

        TId id;
        Type type;
    };

    AffectedObject affectedObject() const
    { return affectedObject_; }

private:
    TId id_;
    std::string timeStart_;
    std::string timeEnd_;
    std::string dateStart_;
    std::string dateEnd_;
    std::string departureTime_;
    int frequency_;
    common::WeekdayFlags weekdays_;
    AffectedObject affectedObject_;
    bool alternative_;
};

} // namespace maps::wiki::validator
