#pragma once

#include <yandex/maps/wiki/validator/common.h>
#include <yandex/maps/wiki/validator/objects/name.h>
#include <maps/libs/geolib/include/polygon.h>

#include <vector>

namespace maps::wiki::validator {

class ServicePolygon {
public:
    using TGeom = geolib3::Polygon2;

    ServicePolygon(
        TId id,
        TGeom geom,
        const AttrMap& attributes,
        const Relations& masters,
        const Relations& slaves);

    TId id() const
    { return id_; }

    const TGeom& geom() const
    { return geom_; }

    const std::string& name() const
    { return name_; }

private:
    TId id_;
    TGeom geom_;
    std::string name_;
};

} // namespace maps::wiki::validator
