#pragma once

#include <yandex/maps/wiki/validator/common.h>

#include <vector>

namespace maps::wiki::validator {

class TrafficLight
{
public:
    TrafficLight(
        TId id,
        const AttrMap& attributes,
        const Relations& masters,
        const Relations& slaves);

    TId id() const
    { return id_; }

    TId placedAtJunction() const
    { return placedAtJunction_; }

    const std::vector<TId>& controlledRoadElements() const
    { return controlledRoadElements_; }

private:
    TId id_;
    TId placedAtJunction_;
    std::vector<TId> controlledRoadElements_;
};

} // namespace maps::wiki::validator
