#pragma once

#include <yandex/maps/wiki/validator/common.h>
#include <maps/libs/enum_io/include/enum_io_fwd.h>

namespace maps::wiki::validator {

enum class BoardingOptions {
    Head,
    MiddleHead,
    Middle,
    MiddleTail,
    Tail
};

DECLARE_ENUM_IO(BoardingOptions);

class TransportPassagewayBoarding {
public:
    TransportPassagewayBoarding(
        TId id,
        const AttrMap& attributes,
        const Relations& masters,
        const Relations& slaves);

    TId id() const
    { return id_; }

    TId passageway() const
    { return passageway_; }

    TId previousStation() const
    { return previousStation_; }

    const std::set<BoardingOptions>& boardingOptions() const
    { return boardingOptions_; }

private:
    TId id_;
    TId passageway_;
    TId previousStation_;
    std::set<BoardingOptions> boardingOptions_;
};

class TransportTransitionBoarding {
public:
    enum class Oneway {
        From,
        To
    };

    TransportTransitionBoarding(
        TId id,
        const AttrMap& attributes,
        const Relations& masters,
        const Relations& slaves);

    TId id() const
    { return id_; }

    TId transition() const
    { return transition_; }

    Oneway oneway() const
    { return oneway_; }

    TId previousStation() const
    { return previousStation_; }

    TId nextStation() const
    { return nextStation_; }

    const std::set<BoardingOptions>& boardingOptions() const
    { return boardingOptions_; }

private:
    TId id_;
    TId transition_;
    Oneway oneway_;
    TId previousStation_;
    TId nextStation_;
    std::set<BoardingOptions> boardingOptions_;
};

} // namespace maps::wiki::validator
