#pragma once

#include <yandex/maps/wiki/validator/common.h>

#include <maps/libs/geolib/include/polyline.h>

#include <vector>

namespace maps::wiki::validator {

class TransportElement
{
public:
    using TGeom = geolib3::Polyline2;

    TransportElement(
        TId id,
        TGeom geom,
        const AttrMap& attributes,
        const Relations& masters,
        const Relations& slaves);

    TId id() const
    { return id_; }

    const TGeom& geom() const
    { return geom_; }

    int fromZlevel() const
    { return fromZlevel_; }

    int toZlevel() const
    { return toZlevel_; }

    TId startJunction() const
    { return startJunction_; }

    TId endJunction() const
    { return endJunction_; }

    const std::vector<TId>& lines() const
    { return lines_; }

    const std::vector<TId>& threads() const
    { return threads_; }

private:
    TId id_;
    TGeom geom_;
    int fromZlevel_;
    int toZlevel_;
    TId startJunction_;
    TId endJunction_;
    std::vector<TId> lines_;
    std::vector<TId> threads_;
};

} // namespace maps::wiki::validator
