#pragma once

#include <yandex/maps/wiki/validator/common.h>
#include <yandex/maps/wiki/validator/objects/name.h>

#include <vector>

namespace maps::wiki::validator {

class TransportLine
{
public:
    TransportLine(
        TId id,
        const AttrMap& attributes,
        const Relations& masters,
        const Relations& slaves);

    TId id() const
    { return id_; }

    // Non-zero only if object category corresponds to multiple feature types
    TFeatureType featureType() const
    { return featureType_; }

    TId transportOperator() const
    { return transportOperator_; }

    const std::vector<TId>& stations() const
    { return stations_; }

    const std::vector<TId>& elements() const
    { return elements_; }

    const std::vector<TId>& threads() const
    { return threads_; }

    const std::vector<NameRelation>& names() const
    { return names_; }

    const std::string& importSourceId() const
    { return importSourceId_; }

    const std::string& importSource() const
    { return importSource_; }

private:
    TId id_;
    TId transportOperator_;
    TFeatureType featureType_;
    std::vector<TId> stations_;
    std::vector<TId> elements_;
    std::vector<TId> threads_;
    std::vector<NameRelation> names_;
    std::string importSourceId_;
    std::string importSource_;
};

} // namespace maps::wiki::validator
