#pragma once

#include <yandex/maps/wiki/validator/common.h>
#include <yandex/maps/wiki/validator/objects/name.h>
#include <maps/libs/geolib/include/point.h>

#include <vector>

namespace maps::wiki::validator {

class TransportMetroExit {
public:
    using TGeom = geolib3::Point2;

    TransportMetroExit(
        TId id,
        TGeom geom,
        const AttrMap& attributes,
        const Relations& masters,
        const Relations& slaves);

    TId id() const
    { return id_; }

    const TGeom& geom() const
    { return geom_; }

    TId station() const
    { return station_; }

    const std::vector<NameRelation>& names() const
    { return names_; }

    const std::vector<TId>& passageways() const
    { return passageways_; }

    const std::string& importSourceId() const
    { return importSourceId_; }

    const std::string& importSource() const
    { return importSource_; }

private:
    TId id_;
    TGeom geom_;
    TId station_;
    std::vector<NameRelation> names_;
    std::vector<TId> passageways_;
    std::string importSourceId_;
    std::string importSource_;
};

} // namespace maps::wiki::validator
