#pragma once

#include <yandex/maps/wiki/validator/common.h>
#include <yandex/maps/wiki/validator/objects/name.h>
#include <maps/libs/geolib/include/point.h>

#include <vector>

namespace maps::wiki::validator {

class TransportMetroStation {
public:
    using TGeom = geolib3::Point2;

    TransportMetroStation(
        TId id,
        TGeom geom,
        const AttrMap& attributes,
        const Relations& masters,
        const Relations& slaves);

    TId id() const
    { return id_; }

    const TGeom& geom() const
    { return geom_; }

    const std::vector<TId>& stops() const
    { return stops_; }

    const std::vector<TId>& exits() const
    { return exits_; }

    TId line() const
    { return line_; }

    const std::vector<NameRelation>& names() const
    { return names_; }

    const std::string& importSourceId() const
    { return importSourceId_; }

    const std::string& importSource() const
    { return importSource_; }

    const std::string& geobaseId() const
    { return geobaseId_; }

private:
    TId id_;
    TGeom geom_;
    std::vector<TId> stops_;
    std::vector<TId> exits_;
    TId line_;
    std::vector<NameRelation> names_;
    std::string importSourceId_;
    std::string importSource_;
    std::string geobaseId_;
};

} // namespace maps::wiki::validator
