#pragma once

#include <yandex/maps/wiki/validator/common.h>
#include <yandex/maps/wiki/validator/objects/name.h>
#include <maps/libs/geolib/include/point.h>

#include <vector>

namespace maps::wiki::validator {

class TransportOperator
{
public:
    using TGeom = geolib3::Point2;

    TransportOperator(
        TId id,
        TGeom geom,
        const AttrMap& attributes,
        const Relations& masters,
        const Relations& slaves);

    TId id() const
    { return id_; }

    const TGeom& geom() const
    { return geom_; }

    const std::vector<NameRelation>& names() const
    { return names_; }

    bool skipValidation() const
    { return skipValidation_; }

private:
    TId id_;
    TGeom geom_;
    std::vector<NameRelation> names_;
    bool skipValidation_;
};

} // namespace maps::wiki::validator
