#pragma once

#include <yandex/maps/wiki/validator/common.h>

namespace maps::wiki::validator {

class TransportPassageway {
public:
    enum class Oneway {
        Both,
        From,
        To
    };

    TransportPassageway(
        TId id,
        const AttrMap& attributes,
        const Relations& masters,
        const Relations& slaves);

    TId id() const
    { return id_; }

    TId station() const
    { return station_; }

    TId exit() const
    { return exit_; }

    TSeconds transitionTime() const
    { return transitionTime_; }

    Oneway oneway() const
    { return oneway_; }

private:
    TId id_;
    TId station_;
    TId exit_;
    TSeconds transitionTime_;
    Oneway oneway_;
};

} // namespace maps::wiki::validator
