#pragma once

#include <yandex/maps/wiki/validator/common.h>

#include <vector>

namespace maps::wiki::validator {

class TransportThread {
public:
    TransportThread(
        TId id,
        const AttrMap& attributes,
        const Relations& masters,
        const Relations& slaves);

    TId id() const
    { return id_; }

    TId line() const
    { return line_; }

    const std::vector<TId>& elements() const
    { return elements_; }

    const std::vector<TId>& stops() const
    { return stops_; }

    const std::vector<TId>& schedules() const
    { return schedules_; }

    const std::string& importSourceId() const
    { return importSourceId_; }

    const std::string& importSource() const
    { return importSource_; }

    bool isCircular() const
    { return isCircular_; }

private:
    TId id_;
    TId line_;
    std::vector<TId> elements_;
    std::vector<TId> stops_;
    std::vector<TId> schedules_;
    std::string importSourceId_;
    std::string importSource_;
    bool isCircular_;
};

} // namespace maps::wiki::validator
