#pragma once

#include <yandex/maps/wiki/validator/common.h>

namespace maps::wiki::validator {

class TransportThreadStop {
public:
    TransportThreadStop(
        TId id,
        const AttrMap& attributes,
        const Relations& masters,
        const Relations& slaves);

    TId id() const
    { return id_; }

    TId previous() const
    { return previous_; }

    TId station() const
    { return station_; }

    TId thread() const
    { return thread_; }

    std::optional<TSeconds> travelTime() const
    { return travelTime_; }

    std::optional<TSeconds> waitTime() const
    { return waitTime_; }

private:
    TId id_;
    TId previous_;
    TId station_;
    TId thread_;
    std::optional<TSeconds> travelTime_;
    std::optional<TSeconds> waitTime_;
};

} // namespace maps::wiki::validator
