#pragma once

#include <yandex/maps/wiki/validator/common.h>

namespace maps::wiki::validator {

class TransportTransition {
public:
    TransportTransition(
        TId id,
        const AttrMap& attributes,
        const Relations& masters,
        const Relations& slaves);

    TId id() const
    { return id_; }

    TId stationA() const
    { return stationA_; }

    TId stationB() const
    { return stationB_; }

    TSeconds transitionTime() const
    { return transitionTime_; }

    bool isOneway() const
    { return oneway_; }

private:
    TId id_;
    TId stationA_;
    TId stationB_;
    TSeconds transitionTime_;
    bool oneway_;
};

} // namespace maps::wiki::validator
