#pragma once

#include <yandex/maps/wiki/validator/common.h>
#include <yandex/maps/wiki/validator/objects/vehicle_restriction_common.h>
#include <yandex/maps/wiki/common/rd/access_id.h>
#include <yandex/maps/wiki/validator/common/relation.h>

namespace maps::wiki::validator {

class VehicleRestriction
{
public:
    VehicleRestriction(
            TId id,
            const AttrMap& attributes,
            const Relations& /* masters */,
            const Relations& slaves);

    TId id() const
    { return id_; }

    common::AccessId accessId() const
    { return accessId_; }

    const std::string& universalId() const
    { return universalId_; }

    const std::string& passId() const
    { return passId_; }

    const std::vector<TId>& restrictsRoadElements() const
    { return restrictsRoadElements_; }

    const std::vector<TId>& restrictsRoadElementsFrom() const
    { return restrictsRoadElementsFrom_; }

    const std::vector<TId>& restrictsRoadElementsTo() const
    { return restrictsRoadElementsTo_; }

    const std::vector<TId>& schedules() const
    { return schedules_; }

    const std::unique_ptr<VehicleRestrictionParameters>& vehicleRestrictionParameters() const
    { return vehicleRestrictionParameters_; }

private:
    TId id_;
    common::AccessId accessId_;
    std::string universalId_;
    std::string passId_;
    std::vector<TId> restrictsRoadElements_;
    std::vector<TId> restrictsRoadElementsFrom_;
    std::vector<TId> restrictsRoadElementsTo_;
    std::vector<TId> schedules_;
    std::unique_ptr<VehicleRestrictionParameters> vehicleRestrictionParameters_;

};

} // namespace maps::wiki::validator
