#pragma once

#include <yandex/maps/wiki/validator/common.h>
#include <maps/libs/enum_io/include/enum_io.h>
#include <memory>

namespace maps::wiki::validator {

enum class EcoClass {
    Euro0,
    Euro1,
    Euro2,
    Euro3,
    Euro4,
    Euro5,
    Euro6,
};
DECLARE_ENUM_IO(EcoClass);

struct VehicleRestrictionParameters
{
    std::optional<double> weightLimit;
    std::optional<double> axleWeightLimit;
    std::optional<double> maxWeightLimit;
    std::optional<double> heightLimit;
    std::optional<double> widthLimit;
    std::optional<double> lengthLimit;
    std::optional<double> payloadLimit;
    std::optional<EcoClass> minEcoClass;
    std::optional<bool> trailerNotAllowed;
};

std::unique_ptr<VehicleRestrictionParameters> readVehicleRestrictionParameters(
    const AttrMap& attributes, TId objectId);

} // namespace maps::wiki::validator
