#pragma once

#include <yandex/maps/wiki/validator/area_of_interest.h>
#include <yandex/maps/wiki/validator/message.h>
#include <maps/libs/common/include/exception.h>

#include <list>
#include <memory>
#include <vector>

namespace maps {
namespace wiki {
namespace validator {

class ValidationCanceledException : public maps::Exception
{
};

class InitializationError : public maps::Exception
{
};

class TaskContext;

class Result
{
public:
    explicit Result(std::unique_ptr<TaskContext> taskContext);
    ~Result();

    DBID branchId() const;
    DBID commitId() const;
    const AreaOfInterest& aoi() const;
    std::vector<TCheckId> checkIds() const;

    typedef std::list<Message> MessageBuffer;
    MessageBuffer popMessages();

    Messages drainAllMessages();

private:
    std::unique_ptr<TaskContext> taskContext_;
};

typedef std::shared_ptr<Result> ResultPtr;

} // namespace validator
} // namespace wiki
} // namespace maps
