#pragma once

#include <yandex/maps/wiki/validator/storage/stored_message_data.h>
#include <yandex/maps/wiki/validator/storage/message_attributes_filter.h>
#include <yandex/maps/wiki/validator/storage/common.h>

#include <yandex/maps/wiki/common/before_after.h>
#include <yandex/maps/wiki/revision/common.h>

#include <maps/libs/chrono/include/time_point.h>
#include <maps/libs/geolib/include/bounding_box.h>

#include <vector>

namespace maps::wiki {
namespace revision {

class Snapshot;

} // namespace revision

namespace validator::storage {

enum class ViewedState {
    Viewed,
    NotViewed
};

struct ViewedByFilter {
    TUId uid;
    ViewedState state;
};

struct ExclusionsFilter
{
    MessageAttributesFilter attributes;
    boost::optional<TUId> createdBy;
    boost::optional<chrono::TimePoint> createdBefore;
    boost::optional<ViewedByFilter> viewedBy;
    boost::optional<geolib3::BoundingBox> bbox;
};

class ExclusionsGateway
{
public:
    struct ResultBeforeAfter
    {
        StoredMessageData exclusions;
        bool hasMore = false;
    };

    explicit ExclusionsGateway(Transaction& txn);

    StoredMessageDatum addExclusion(
        const MessageId& messageId,
        TUId createdBy,
        const revision::Snapshot& snapshot) const;

    StoredMessageDatum removeExclusion(
        const MessageId& messageId,
        const revision::Snapshot& snapshot) const;

    StoredMessageDatum viewExclusion(
        const MessageId& messageId,
        TUId viewedBy,
        const revision::Snapshot& snapshot) const;

    MessageStatistics statistics(
        const ExclusionsFilter& filter) const;

    // Default output sorting is in reverse chronological order by creation time.
    ResultBeforeAfter exclusions(
        const ExclusionsFilter& filter,
        const revision::Snapshot& snapshot,
        const MessageId& startID,
        common::BeforeAfter beforeAfter,
        size_t limit) const;

    StoredMessageData exclusions(
        const ExclusionsFilter& filter,
        const revision::Snapshot& snapshot,
        size_t offset, size_t limit) const;

    std::vector<Message> exclusionsForCheck(
        const TCheckId& check,
        const boost::optional<geolib3::BoundingBox>& aoiBbox) const;

private:
    Transaction& txn_;
};

} // namespace validator::storage
} // namespace maps::wiki
