#pragma once

#include <yandex/maps/wiki/validator/common.h>
#include <yandex/maps/wiki/validator/storage/stored_message_data.h>

#include <maps/libs/st/include/st.h>

#include <string>

namespace maps::wiki::validator::storage {

class IssueCreator
{
public:
    explicit IssueCreator(std::string baseUrl);
    IssueCreator(std::string baseUrl, std::string oAuthToken);

    std::string getOrCreateIssue(
        pqxx::transaction_base& txn,
        const MessageId& messageId,
        TId branchId,
        const std::string& reporterLogin,
        const std::string& pageUrl);

private:
    std::string createIssue(
        pqxx::transaction_base& txn,
        const MessageId& messageId,
        TId branchId,
        const std::string& reporterLogin,
        const std::string& pageUrl);

    std::string findIssue(const MessageId& messageId);

    st::Gateway stGateway_;
};

} // namespace maps::wiki::validatior
