#pragma once

#include <yandex/maps/wiki/validator/storage/common.h>
#include <yandex/maps/wiki/validator/message.h>

#include <maps/libs/pgpool/include/pgpool3.h>

#include <vector>

namespace maps::wiki::validator::storage {

/**
 * Write results of validation_worker to validation.task_message table
 */
class MessagesWriter
{
public:
    MessagesWriter(pgpool3::Pool& pgPool, TTaskId taskId);

    /**
     * Workaround for the problems with the DBaaS broken connections
     * @retval true The result has been successfully stored.
     * @retval false The result has not been stored because of DB connection problems.
     */
    bool writeMessagesBatchWithRetries(const std::vector<Message>& messages);

private:
    pgpool3::Pool& pgPool_;
    TTaskId taskId_;
};

} // namespace maps::wiki::validator::storage
