#pragma once

#include <yandex/maps/wiki/validator/storage/stored_message_data.h>
#include <yandex/maps/wiki/validator/storage/common.h>
#include <yandex/maps/wiki/validator/result.h>

#include <yandex/maps/wiki/revision/common.h>

#include <vector>

namespace maps {
namespace pgpool3 {

class Pool;

} // namespace pgpool3

namespace wiki {
namespace revision {

class Snapshot;

} // namespace revision

namespace validator::storage {

struct MessageAttributesFilter;

/**
 * @retval true The result has been successfully stored.
 * @retval false The result has not been stored because of DB connection problems.
 */
bool storeResult(ResultPtr result, pgpool3::Pool& pgPool, TTaskId taskId);

class ResultsGateway
{
public:
    ResultsGateway(Transaction& txn, TTaskId taskId);

    TTaskId taskId() const { return taskId_; }

    size_t messageCount() const;
    size_t messageCount(const MessageAttributesFilter& filters) const;

    MessageStatistics statistics(const MessageAttributesFilter& filter) const;

    StoredMessageData messages(
        const MessageAttributesFilter& filter,
        const revision::Snapshot& snapshot,
        size_t offset, size_t limit, revision::UserID uid = 0) const;

    StoredMessageDatum messageSetViewed(
        const revision::Snapshot& snapshot,
        revision::UserID uid,
        const MessageId& messageId) const;

    std::vector<TCheckId> checkIdsWithFatalErrors() const;

private:
    Transaction& txn_;
    TTaskId taskId_;
};

} // namespace validator::storage
} // namespace wiki
} // namespace maps
