#pragma once

#include <yandex/maps/wiki/validator/common.h>
#include <yandex/maps/wiki/configs/editor/config_holder.h>

#include <boost/filesystem/path.hpp>

namespace maps::wiki::validator {

class DataSource;
class RevisionIdsLoadersStore;

using RevisionIdsLoaderFunc = std::function<RevisionIds(DataSource&)>;

enum class LoaderType
{
    LoadAll,
    LoadFromAoi,
    LoadBySelectedObjects
};

std::ostream& operator<<(std::ostream& stream, LoaderType loaderType);

/**
 * Contains persistent validation parameters
 */
class ValidatorConfig
{
public:
    ValidatorConfig(); // load editor config from resource
    explicit ValidatorConfig(const boost::filesystem::path& editorConfigPath);
    ~ValidatorConfig();

    const configs::editor::ConfigHolder& editorConfig() const { return editorConfig_; }

    /**
     * Returns the loader function that loads revision ids depending on previsously loaded categories
     */
    const RevisionIdsLoaderFunc& categoryRevisionIdsLoader(const TCategoryId& categoryId, LoaderType loaderType) const;

    /**
     * Return categories that the given category depends on
     */
    const std::set<TCategoryId>& loaderDependencies(const TCategoryId& categoryId, LoaderType loaderType) const;

private:
    configs::editor::ConfigHolder editorConfig_;
    std::unique_ptr<RevisionIdsLoadersStore> revisionIdsLoaders_;
};

} // namespace maps::wiki::validator
