#pragma once

#include "revisions_loaders.h"

#include <yandex/maps/wiki/validator/validator_config.h>

namespace maps {
namespace wiki {
namespace validator {

class RevisionIdsLoadersStore
{
public:
    RevisionIdsLoadersStore(const configs::editor::ConfigHolder& editorConfig);

    bool hasLoader(const TCategoryId& categoryId, LoaderType loaderType) const;

    const RevisionIdsLoader& loader(const TCategoryId& categoryId, LoaderType loaderType) const;

private:
    void insertCustomLoaders(const configs::editor::ConfigHolder& editorConfig);
    void insertLoadersFromConfig(const configs::editor::ConfigHolder& editorConfig);

    void insertLoader(TCategoryId categoryId, LoaderType loaderType, RevisionIdsLoader loader);

    void insertTransportThreadLoader(
        const TCategoryId& categoryId,
        const std::set<TCategoryId>& otherCategories);

    void insertByRelatedIdsLoader(
        const TCategoryId& categoryId,
        LoaderType loaderType,
        const std::set<TCategoryId>& otherCategories,
        const std::set<std::string>& roleIds,
        RelationType relationType);

    std::map<LoaderType, std::unordered_map<TCategoryId, RevisionIdsLoader>> loadersByCategory_;
};

} // namespace validator
} // namespace wiki
} // namespace maps
