#pragma once

#include "db_gateway.h"
#include "important_regions.h"
#include "category_revisions_loader.h"
#include <maps/wikimap/mapspro/libs/validator/content/objects_collection_base.h>
#include <maps/wikimap/mapspro/libs/validator/content/objects_collections_tuple.h>

#include <yandex/maps/wiki/validator/area_of_interest.h>
#include <yandex/maps/wiki/validator/validator_config.h>
#include <yandex/maps/wiki/configs/editor/fwd.h>

#include <vector>

namespace maps {
namespace wiki {

class ThreadPool;

namespace validator {

enum class CheckCardinality
{
    Yes,
    No
};

class DataSource : boost::noncopyable
{
public:
    DataSource(
            const ValidatorConfig& validatorConfig,
            CheckCardinality checkCardinality,
            pgpool3::Pool& pgPool,
            revision::DBID branchId,
            revision::DBID commitId,
            AreaOfInterest aoi,
            const ObjectIdSet& objectIds);

    const DBGateway& dbGateway() const
    { return dbGateway_; }

    const AreaOfInterest& aoi() const
    { return aoi_; }

    bool hasSelectedObjectIds() const
    { return !selectedObjectIdsByCategory_.empty(); }

    const ObjectIdSet& selectedObjectIds(const TCategoryId& categoryId) const;

    const ImportantRegions& importantRegions() const
    { return importantRegions_; }

    pgpool3::TransactionHandle getTransaction() const
    { return dbGateway_.getTransaction(); }


    std::list<Message> load(
            const TCategoryId& category,
            LoaderType loaderType,
            ThreadPool& dbReadWorkers);

    void unload(const TCategoryId& category);

    const std::set<TCategoryId>& dependencies(const TCategoryId& category, LoaderType loaderType) const;

    const ObjectsCollectionBase& collection(const TCategoryId&) const;

    const ObjectsCollectionsTuple& collectionsTuple() const
    { return collectionsTuple_; }

    RevisionID objectRevisionId(
            TId objectId, const std::vector<TCategoryId>& possibleCategoryIds) const;

private:
    const ValidatorConfig& validatorConfig_;
    CheckCardinality checkCardinality_;
    DBGateway dbGateway_;
    AreaOfInterest aoi_;
    CategoryIdToObjectIds selectedObjectIdsByCategory_;
    ImportantRegions importantRegions_;
    ObjectsCollectionsTuple collectionsTuple_;
    ObjectsCollectionsMap collections_;
};

} // namespace validator
} // namespace wiki
} // namespace maps
