#include "helper_loaders.h"
#include "data_source.h"

#include <yandex/maps/wiki/common/retry_duration.h>

namespace maps::wiki::validator {

ObjectIdSet loadObjectIdsByRelatedIds(
    DataSource& dataSource,
    const TCategoryId& categoryId,
    const std::vector<TId>& relatedIds,
    RelationType relationType,
    const std::set<std::string>& roleIds)
{
    const auto& dbGateway = dataSource.dbGateway();

    return common::retryDuration([&] {
        auto txn = dbGateway.getTransaction();
        return dbGateway.loadObjectIdsByRelatedIds(
            *txn, categoryId, relatedIds, relationType, roleIds);
    });
}

RevisionIds revisionIdsByFilter(
    DataSource& dataSource,
    const revision::filters::FilterExpr& filter)
{
    const auto& dbGateway = dataSource.dbGateway();

    return common::retryDuration([&] {
        auto txn = dbGateway.getTransaction();
        return dbGateway.revisionIdsByFilter(filter, *txn);
    });
}

RevisionIds revisionIdsByObjectIds(
    DataSource& dataSource,
    const revision::ConstRange<TId>& ids)
{
    const auto& dbGateway = dataSource.dbGateway();

    return common::retryDuration([&] {
        auto txn = dbGateway.getTransaction();
        return dbGateway.revisionIdsByObjectIds(ids, *txn);
    });
}

} // namespace maps::wiki::validator
