#pragma once

#include "db_gateway.h"

namespace maps::wiki::validator {

class DataSource;

ObjectIdSet loadObjectIdsByRelatedIds(
    DataSource& dataSource,
    const TCategoryId& categoryId,
    const std::vector<TId>& relatedIds,
    RelationType relationType,
    const std::set<std::string>& roleIds);

RevisionIds revisionIdsByFilter(
    DataSource& dataSource,
    const revision::filters::FilterExpr& filter);

RevisionIds revisionIdsByObjectIds(
    DataSource& dataSource,
    const revision::ConstRange<TId>& ids);

} // namespace maps::wiki::validator
