#pragma once

#include "db_gateway.h"

#include <yandex/maps/wiki/validator/validator_config.h>

#include <functional>
#include <set>

namespace maps::wiki::validator {

class DataSource;

struct RevisionIdsLoader
{
    RevisionIdsLoaderFunc load;

    std::set<TCategoryId> dependencies;
};

RevisionIdsLoader createAllRevisionIdsLoader(const TCategoryId& categoryId);

RevisionIdsLoader
createByRelatedIdsLoader(
    const TCategoryId& categoryId,
    const std::set<TCategoryId>& otherCategories,
    const std::set<std::string>& roleIds,
    RelationType relationType);

RevisionIdsLoader createInsideAoiRevisionIdsLoader(const TCategoryId& categoryId);

RevisionIdsLoader createAdmUnitLoader();

} // namespace maps::wiki::validator
