#include <yandex/maps/wiki/validator/objects/adm_unit.h>

#include "object_init_helpers.h"
#include <maps/wikimap/mapspro/libs/validator/common/magic_strings.h>

namespace maps::wiki::validator {

AdmUnit::AdmUnit(
        TId id,
        const AttrMap& attributes,
        const Relations& masters,
        const Relations& slaves)
    : AdmUnitCommon(id, CHILD_ROLE, attributes, masters, slaves)
    , center_(
        extractRelation(
            slaves, CENTER_ROLE, IsMandatory::No, "bad-center-relation", id))
    , addrUnity_(
        extractRelation(
            masters, ASSIGNED_AD_ROLE, IsMandatory::No, "ad-shared-by-addr-unities", id))
    , isLeaf_(true)
    , isAddrUnity_(extractAttrBySuffix<bool>(
                    attributes, ADDR_UNITY_ATTR_SUFFIX, IsMandatory::No,
                    "bad-addr_unity-flag", id))
{
    for (const auto& slaveRel : slaves) {
        if (slaveRel.role == CHILD_ROLE) {
            isLeaf_ = false;
            break;
        }
    }
}

} // namespace maps::wiki::validator
