#include <yandex/maps/wiki/validator/objects/adm_unit_common.h>

#include "object_init_helpers.h"
#include <maps/wikimap/mapspro/libs/validator/common/magic_strings.h>

#include <boost/algorithm/string/split.hpp>

namespace maps::wiki::validator {

AdmUnitCommon::AdmUnitCommon(
        TId id,
        const std::string& childRoleId,
        const AttrMap& attributes,
        const Relations& masters,
        const Relations& slaves)
    : id_(id)
    , levelKind_(
            extractAttrBySuffix<LevelKind>(
                    attributes, LEVEL_KIND_ATTR_SUFFIX, IsMandatory::Yes,
                    "bad-level-kind", id))
    , isoCode_(
            extractAttrBySuffix<TIsoCode>(
                    attributes, ISO_CODE_ATTR_SUFFIX, IsMandatory::No,
                    TIsoCode(), id)) // may never report an error
    , isTown_(
            extractAttrBySuffix<bool>(
                    attributes, TOWN_ATTR_SUFFIX, IsMandatory::No,
                    "bad-town-flag", id))
    , isInformal_(extractAttrBySuffix<bool>(
                    attributes, INFORMAL_ATTR_SUFFIX, IsMandatory::No,
                    "bad-informal-flag", id))
    , isMunicipality_(extractAttrBySuffix<bool>(
                    attributes, MUNICIPALITY_ATTR_SUFFIX, IsMandatory::No,
                    "bad-municipality-flag", id))
    , parent_(
            extractRelation(
                    masters, childRoleId, IsMandatory::No,
                    MESSAGE_BAD_PARENT_RELATION, id))
    , faces_(extractRelations(slaves, PART_ROLE))
    , names_(extractNameRelations(slaves))
    , addressExclusions_(extractRelations(slaves, EXCLUSION_ROLE))
    , geobaseId_(extractGeobaseId(attributes, id))
{
    auto recognitionIsoCodesList = extractAttrBySuffix<TIsoCode>(
        attributes, RECOGNITION_ATTR_SUFFIX, IsMandatory::No,
        TIsoCode(), id);
    if (!recognitionIsoCodesList.empty()) {
        boost::split(recognitionIsoCodes_, recognitionIsoCodesList,
            [] (char c) { return c == MULTIVALUE_ATTR_DELIMITER; });
    }
}

} // namespace maps::wiki::validator
