#include <yandex/maps/wiki/validator/objects/adm_unit_subst.h>

#include "object_init_helpers.h"
#include <maps/wikimap/mapspro/libs/validator/common/magic_strings.h>

namespace maps::wiki::validator {

AdmUnitSubst::AdmUnitSubst(
        TId id,
        const AttrMap& attributes,
        const Relations& masters,
        const Relations& slaves)
    : AdmUnitCommon(id, AD_SUBST_CHILD_ROLE, attributes, masters, slaves)
    , generalHierarchyId_(
        extractRelation(
            masters, SUBSTITUTION_ROLE, IsMandatory::Yes,
            "bad-substitution-relation", id))
    , isVirtual_(
        extractAttr<bool>(
            attributes, AD_SUBST_IS_VIRTUAL_ATTR, IsMandatory::No,
              std::string(), id))
{}

} // namespace maps::wiki::validator
